//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

#ifdef _WIN32
#include "StdAfx.h"
#include <io.h>
#include "utf8util.h"
#endif
#ifdef __unix__
#include <unistd.h>
#endif
#include <stdlib.h>
#include "sqpplusrunner.h"

/*
  main
*/

#ifdef _WIN32

int _tmain(int argc, TCHAR* argv[], TCHAR* /*envp[]*/)
{
   FILE* pOutFile;
   char* utf8str;
   SQPBatchRunner oSQPRunner;

   if (argc == 1)
   {
      _ftprintf(stderr, _T("\n%s: Usage:\n\n")
         _T(".\\SQPPlusCSample.exe <USP file> [output file]\n\n")
         _T("    USP file      --- is a SIMCA project file\n")
         _T("    output file   --- is a file to write output.\n\n"), argv[0]);
      return -1;
   }

   if (_taccess(argv[1], 04) != 0)
   {
      _ftprintf(stderr, _T("\n%s: Could not open: %s\n")
         _T("Make sure that the file is not missing, is a SIMCA project ")
         _T("and is readable for your user\n\n"), argv[0], argv[1]);
      return -1;
   }

   utf8str = TCHARtoUTF8(argv[1]);
   SQPBatchRunner_Init(&oSQPRunner, utf8str);
   free(utf8str);

   if (argc > 2)
   {
      pOutFile = _wfopen(argv[2], L"w");
      if (pOutFile == NULL)
      {
         _ftprintf(stderr, _T("%s: Could not open output file: ")
            _T("%s\nWriting output to standard out\n"), argv[0], argv[2]);
      }
      else
      {
         SQPBatchRunner_Run(&oSQPRunner, pOutFile, stderr);

         fclose(pOutFile);
         SQPBatchRunner_Destroy(&oSQPRunner);

         return 0;
      }
   }

   SQPBatchRunner_Run(&oSQPRunner, stdout, stderr);
   SQPBatchRunner_Destroy(&oSQPRunner);

   return 0;
}

#else
int main(int argc, char ** argv)
{
   FILE* pOutFile;
   SQPBatchRunner oSQPRunner;

   if (argc == 1)
   {
      fprintf(stderr, "%s: Usage:\nsqp USP file [output file]\n"
              "USP file is a SIMCA project file\n"
              "output file is a file to write output.\n", argv[0]);
      return -1;
   }

   if (access(argv[1], 04) != 0)
   {
      fprintf(stderr, "%s: Could not open: %s\n"
              "Make sure that the file is not missing, is a SIMCA project "
              "and is readable for your user\n", argv[0], argv[1]);
      return -1;
   }

   SQPBatchRunner_Init(&oSQPRunner, argv[1]);  

   if (argc > 2)
   {
      pOutFile = fopen(argv[2], "w");
      if (pOutFile == NULL)
      {
         fprintf(stderr, "%s: Could not open output file: "
                 "%s\nWriting output to standard out\n", argv[0], argv[2]);
      }
      else
      {
         SQPBatchRunner_Run(&oSQPRunner, pOutFile, stderr);

         fclose(pOutFile);
         SQPBatchRunner_Destroy(&oSQPRunner);

         return 0;
      }
   }

   SQPBatchRunner_Run(&oSQPRunner, stdout, stderr);
   SQPBatchRunner_Destroy(&oSQPRunner);

   return 0;
}

#endif
